bl_info = {
    "name": "by vfxmed.com Selection To Mask",
    "blender": (2, 80, 0),
    "category": "Mesh",
}

import bpy


class SelectionToMask(bpy.types.Operator):
    """Select Vertices to create mask in Sculpt mode"""      # Use this as a tooltip for menu items and buttons.
    bl_idname = "edit_mesh.selection_to_mask"        # Unique identifier for buttons and menu items to reference.
    bl_label = "Selection To Mask"         # Display name in the interface.
    bl_options = {'REGISTER', 'UNDO'}  # Enable undo for the operator.

    def execute(self, context):        # execute() is called when running the operator.

        # The original script
        bpy.ops.mesh.hide(unselected=True)
        bpy.ops.object.editmode_toggle()
        bpy.ops.sculpt.sculptmode_toggle()
        bpy.ops.paint.mask_flood_fill(mode='VALUE', value=1)
        bpy.ops.sculpt.sculptmode_toggle()
        bpy.ops.object.editmode_toggle()
        bpy.ops.mesh.reveal()
        bpy.ops.object.editmode_toggle()
        bpy.ops.sculpt.sculptmode_toggle()
        bpy.ops.sculpt.face_sets_create(mode='VISIBLE')

        return {'FINISHED'}            # Lets Blender know the operator finished successfully.

def menu_func(self, context):
    self.layout.operator(SelectionToMask.bl_idname)

def register():
    bpy.utils.register_class(SelectionToMask)
    bpy.types.VIEW3D_MT_edit_mesh.append(menu_func)  # Adds the new operator to an existing menu.

def unregister():
    bpy.utils.unregister_class(SelectionToMask)


# This allows you to run the script directly from Blender's Text editor
# to test the add-on without having to install it.
if __name__ == "__main__":
    register()